﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace MDVV
{
    public enum BaudRate
    {
        [Description("2400")]
        Baud2400 = 0,
        [Description("4800")]
        Baud4800 = 1,
        [Description("9600")]
        Baud9600 = 2,
        [Description("14400")]
        Baud14400 = 3,
        [Description("19200")]
        Baud19200 = 4,
        [Description("38400")]
        Baud38400 = 6,
        [Description("57600")]
        Baud57600 = 7,
        [Description("115200")]
        Baud115200 = 8
    }

    public enum Parity
    {
        [Description("Отсутствует")]
        None = 0,
        [Description("Чет")]
        Even = 1,
        [Description("Нечет")]
        Odd = 2
    }

    public enum DataBits
    {
        [Description("7")]
        Seven = 0,
        [Description("8")]
        Eight = 1
    }

    public enum StopBits
    {
        [Description("1")]
        One = 0,
        [Description("2")]
        Two = 2
    }

    public enum ConverterType
    {
        Auto = 1,
        SemiAuto = 0
    }

    public enum ConnectionError
    {
        Ok = 0,

        InvalidArgument = -1,
        PortNotOpened = -2,
        PortError = -5,
        Io = -100,
        Format = -101,
        Timeout = -102,
        InvalidCrc = -103,
        NErr = -104,
        Exception = -105,
        InvalidPacket = -106,
        SensorFailure = -300
    }

    public partial class FormMDVV : Form
    {
        private const int deviceAddress = 16;

        public FormMDVV()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            ConnectionError res = (ConnectionError)NativeMethods.OpenPort(
                0, (int)BaudRate.Baud9600, (int)Parity.None, (int)DataBits.Eight, (int)StopBits.One, (int)ConverterType.Auto);

            if (res != ConnectionError.Ok)
            {
                MessageBox.Show("Ошибка открытия порта: " + res.ToString());
            }
        }


        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            NativeMethods.ClosePort();
        }

        private void buttonReadROE_Click(object sender, EventArgs e)
        {
            IntPtr name = Marshal.StringToCoTaskMemAnsi("r.OE");

            for (int i = 0; i < 8; ++i)
            {
                float value = 0;
                int time = 0;

                ConnectionError res = (ConnectionError)NativeMethods.ReadIEEE32(
                    deviceAddress + i, 0, name, ref value, ref time, -1);

                if (res == ConnectionError.Ok)
                {
                    textBoxMemo.Text = value.ToString();
                }
                else
                {
                    MessageBox.Show("Ошибка чтения r.OE: " + res.ToString());
                    break;
                }
            }

            Marshal.FreeCoTaskMem(name);
        }

        private void buttonReadRCN_Click(object sender, EventArgs e)
        {
            IntPtr name = Marshal.StringToCoTaskMemAnsi("r.Cn");

            int bitMask = 0;

            ConnectionError res = (ConnectionError)NativeMethods.ReadUInt(
                deviceAddress, 0, name, ref bitMask, -1);

            if (res == ConnectionError.Ok)
            {
                string inputs = string.Empty;

                for (int i = 12; --i >= 0; )
                {
                    if (((1 << i) & bitMask) != 0)
                        inputs += '1';
                    else
                        inputs += '0';
                }

                textBoxMemo.Text = inputs;
            }
            else
                MessageBox.Show("Ошибка чтения r.Cn: " + res.ToString());

            Marshal.FreeCoTaskMem(name);
        }

        private void buttonWriteROE_Click(object sender, EventArgs e)
        {
            try
            {
                int channel = Convert.ToInt32(textBoxChannel.Text);
                float value = Convert.ToSingle(textBoxValue.Text);

                IntPtr name = Marshal.StringToCoTaskMemAnsi("r.OE");

                ConnectionError res = (ConnectionError)NativeMethods.WriteIEEE32(
                    deviceAddress + channel - 1, 0, name, value, -1);

                Marshal.FreeCoTaskMem(name);

                if (res != ConnectionError.Ok)
                    MessageBox.Show("Ошибка записи r.OE: " + res.ToString());
            }
            catch (FormatException)
            {
                MessageBox.Show("Неверный формат значения или индекса.");
            }
        }
    }

    partial class NativeMethods
    {
        [DllImportAttribute("owen_io.dll", EntryPoint = "OpenPort", CallingConvention = CallingConvention.StdCall)]
        public static extern int OpenPort(int n, int speed, int part, int bits, int stop, int vid);

        [DllImportAttribute("owen_io.dll", EntryPoint = "ClosePort", CallingConvention = CallingConvention.StdCall)]
        public static extern int ClosePort();

        [DllImportAttribute("owen_io.dll", EntryPoint = "ReadIEEE32", CallingConvention = CallingConvention.StdCall)]
        public static extern int ReadIEEE32(int adr, int adr_type, System.IntPtr command, ref float value, ref int time, int index);

        [DllImportAttribute("owen_io.dll", EntryPoint = "ReadUInt", CallingConvention = CallingConvention.StdCall)]
        public static extern int ReadUInt(int adr, int adr_type, System.IntPtr command, ref int value, int index);

        [DllImportAttribute("owen_io.dll", EntryPoint = "WriteIEEE32", CallingConvention = CallingConvention.StdCall)]
        public static extern int WriteIEEE32(int adr, int adr_type, System.IntPtr command, float value, int index);
    }
}
